import { world, BlockPermutation } from '@minecraft/server';

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:araucaria_log', {
        onPlayerInteract(e) {
            const { block, player } = e;
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (!selectedItem?.hasTag('minecraft:is_axe')) return;
            const blockState = block.permutation.getState("minecraft:block_face");
            if (blockState) {
                const strippedLog = BlockPermutation.resolve('v360:stripped_araucaria_log', { "minecraft:block_face": blockState });
                block.setPermutation(strippedLog);
            }
        }
    });
});

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:araucaria_log_destroy', {
        onPlayerDestroy: ({ block }) => {
            const { x, y, z } = block.location
            const placedBlockPerm = BlockPermutation.resolve("v360:decay_araucaria_leaves", { "v360:should_decay": true })
            const replacedBlockPerm = BlockPermutation.resolve("v360:decay_araucaria_leaves", { "v360:should_decay": false })
            block.dimension.fillBlocks({ x: x - 3, y: y - 3, z: z - 3 }, { x: x + 3, y: y + 3, z: z + 3 }, placedBlockPerm, { matchingBlock: replacedBlockPerm })
        }
    })
})